VERSION 5.00
Begin VB.Form SecureClient 
   Caption         =   "Secure Client"
   ClientHeight    =   6444
   ClientLeft      =   5292
   ClientTop       =   348
   ClientWidth     =   5544
   LinkTopic       =   "Form1"
   ScaleHeight     =   6444
   ScaleWidth      =   5544
   Begin VB.CommandButton Auth 
      Caption         =   "Authenticated"
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   3360
      Width           =   2655
   End
   Begin VB.CommandButton Auth2 
      Caption         =   "Non-Authenticated - Check Cert"
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   4320
      Width           =   2655
   End
   Begin VB.CommandButton NonAuth2 
      Caption         =   "Non-Authenticated - Check Cert"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   2400
      Width           =   2655
   End
   Begin VB.TextBox Result 
      Height          =   285
      Left            =   2880
      TabIndex        =   3
      Top             =   960
      Width           =   1215
   End
   Begin VB.CommandButton NonAuth 
      Caption         =   "Non-Authenticated"
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   1440
      Width           =   2655
   End
   Begin VB.Label Label6 
      Caption         =   "This option is fully encrypted, and a client certificate is sent, but the server identify is only checked AFTER the transaction."
      Height          =   495
      Left            =   120
      TabIndex        =   10
      Top             =   3720
      Width           =   5295
   End
   Begin VB.Label Label5 
      Caption         =   "This option is fully encrypted, and no client certificate is sent, but the server identify is checked BEFORE the transaction"
      Height          =   495
      Left            =   120
      TabIndex        =   9
      Top             =   4680
      Width           =   5295
   End
   Begin VB.Label Label4 
      Caption         =   "This option is fully encrypted, and no client certificate is sent, but the server identify is checked BEFORE the transaction"
      Height          =   495
      Left            =   120
      TabIndex        =   6
      Top             =   2760
      Width           =   5295
   End
   Begin VB.Label Label3 
      Caption         =   "Verify Result (should be 0)"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   960
      Width           =   2535
   End
   Begin VB.Label Label2 
      Caption         =   "This option is fully encrypted, but no client certificate is sent, and the server identify is only checked AFTER the transaction"
      Height          =   495
      Left            =   120
      TabIndex        =   2
      Top             =   1800
      Width           =   5295
   End
   Begin VB.Label Label1 
      Caption         =   "This application sends secure C-ECHO requests off to the secure server in various ways."
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   240
      Width           =   3495
   End
End
Attribute VB_Name = "SecureClient"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim MyCert As Certificate, MasterCert As Certificate

Private Sub Form_Load()
    ' First load the certificates we use
    
    ' Note that MyCert must have a private key, but that MasterCert need not
    Set MyCert = New Certificate
    MyCert.Load App.Path & "\dicomclient.pfx"
    Set MasterCert = New Certificate
    MasterCert.Load App.Path & "\master.cer"
    
    Dim g As New DicomGlobal
    Me.Caption = Me.Caption & " DicomObjects v" & g.Version
End Sub
Function CheckCert(cert As Certificate) As Boolean
    '  verify server certificate
    
    ' The "Simple" way to do this would be to use
    ' cert.IsValid but this would be checking against a generic list of trusted
    ' roots, so ANY server with a Verisgn issued certificate would pass!
    
    ' Instead, here, we assume a simplistic hospital PKI system,
    ' and simply check that the root certificate is the correct Master root
    
    Dim CertChain As New Chain
    CertChain.Build cert ' this now contains full chain back to the root
    
    If CertChain.Certificates(CertChain.Certificates.Count).Thumbprint = MasterCert.Thumbprint Then
        MsgBox "Server certificate is OK"
        CheckCert = True
    Else
        MsgBox "Server certificate is not known"
        CheckCert = False
    End If

End Function


Private Sub NonAuth_Click()
    Dim g As New DicomGlobal
    Result = g.EchoSecure("localhost", 2763, "Me", "You", Nothing)
    CheckCert g.LastRemoteCertificate
End Sub

Private Sub NonAuth2_Click()
    Dim cn As New DicomConnection ' just use synchronous here
    cn.UseTLS = True
    cn.SetDestination "localhost", 2763, "Me", "You"
    ' we have only made a connectionso far - now check we can trust it
    If CheckCert(cn.RemoteCertificate) Then
        'Now do some work
        cn.SendVerify
        Result = cn.LastStatus
    End If
End Sub

Private Sub Auth_Click()
    Dim g As New DicomGlobal
    Result = g.EchoSecure("localhost", 2762, "Me", "You", MyCert)
    CheckCert g.LastRemoteCertificate
End Sub
Private Sub Auth2_Click()
    Dim cn As New DicomConnection ' just use synchronous here
    cn.UseTLS = True
    Set cn.LocalCertificate = MyCert
    cn.SetDestination "localhost", 2762, "Me", "You"
    ' we have only made a connectionso far - now check we can trust it
    If CheckCert(cn.RemoteCertificate) Then
        'Now do some work
        cn.SendVerify
        Result = cn.LastStatus
    End If
End Sub
